<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MenuItem extends Model
{
    public $incrementing = false; // 👈 Don't auto-increment
    protected $keyType = 'string'; // 👈 Use string as primary key
    //

    public function children()
    {
        return $this->hasMany(MenuItem::class, 'parent_id', 'id')
            ->with('children.page')
            ->with('page')
            ->orderBy('order');
    }

    public function page()
    {
        return $this->belongsTo(Page::class);
    }
   
}
