<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('apps', function (Blueprint $table) {
            $table->string('mobile')->default('');
            $table->string('profile_pic')->default('');
            $table->string('cover_pic')->default('');
            $table->string('template')->default('');
            $table->boolean('status')->default(true);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('apps', function (Blueprint $table) {
            $table->dropColumn('mobile');
            $table->dropColumn('profile_pic');
            $table->dropColumn('cover_pic');
            $table->dropColumn('template');
            $table->dropColumn('status');
        });
    }
};
