<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('app_testimonials', function (Blueprint $table) {
            $table->id();
            $table->string('name')->default('');
            $table->text('description')->default('');
            $table->string('image')->default('');
            $table->foreignId('app_id')
                ->nullable()
                ->constrained('apps')
                ->onDelete('set null');
            $table->integer('order')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('app_testimonials');
    }
};
