<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('headers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('menu_id')
                ->nullable()
                ->constrained('menus')
                ->onDelete('set null');
            $table->string('text_color')->default('');
            $table->string('bg_color')->default('');
            $table->string('logo')->default('');
            $table->string('sub_text_color')->default('');
            $table->string('sub_bg_color')->default('');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('headers');
    }
};
