<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->boolean('under_construction')->default(false);
        });

        Schema::table('pages', function (Blueprint $table) {
            $table->string('type')->default('page');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn('under_construction');
        });

        Schema::table('pages', function (Blueprint $table) {
            $table->dropColumn('type');
        });
    }
};
