<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FooterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('footers')->insert([
            'component' => '<footer class="footer-twotier" role="contentinfo">
        
        <!-- Top Tier: Main navigation and information -->
        <div class="footer-twotier__top">
            <div class="footer-twotier__top-container">
                <div class="footer-twotier__brand">
                     <svg class="logo" viewBox="0 0 100 30" xmlns="http://www.w3.org/2000/svg" aria-labelledby="logoTitleTiered">
                        <title id="logoTitleTiered">Your Brand Logo</title>
                        <text x="0" y="25" font-family="Arial, sans-serif" font-size="28" font-weight="bold">BRAND</text>
                     </svg>
                     <p>A professional footer for websites that mean business. Organize your links and present a polished image.</p>
                </div>
                <div class="footer-twotier__links">
                    <h3 class="footer-twotier__heading">Products</h3>
                    <ul>
                        <li><a href="#">Web Templates</a></li>
                        <li><a href="#">Code Snippets</a></li>
                        <li><a href="#">UI Kits</a></li>
                        <li><a href="#">Design Assets</a></li>
                    </ul>
                </div>
                 <div class="footer-twotier__links">
                    <h3 class="footer-twotier__heading">Company</h3>
                    <ul>
                        <li><a href="#">About Us</a></li>
                        <li><a href="#">Blog</a></li>
                        <li><a href="#">Careers</a></li>
                        <li><a href="#">Contact</a></li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Bottom Tier: Copyright and social links -->
        <div class="footer-twotier__bottom">
            <div class="footer-twotier__bottom-container">
                <p class="footer-twotier__copyright">
                    &copy; 2024 Your Company, Inc. All rights reserved.
                </p>
                <nav class="footer-twotier__social" aria-label="Social Media">
                    <ul>
                        <li><a href="#" aria-label="Our Twitter Profile"><svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false"><title>Twitter</title><path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.223.085 4.93 4.93 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/></svg></a></li>
                        <li><a href="#" aria-label="Our GitHub Profile"><svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false"><title>GitHub</title><path d="M12 .297c-6.63 0-12 5.373-12 12 0 5.303 3.438 9.8 8.205 11.385.6.113.82-.258.82-.577 0-.285-.01-1.04-.015-2.04-3.338.724-4.042-1.61-4.042-1.61C4.422 18.07 3.633 17.7 3.633 17.7c-1.087-.744.084-.729.084-.729 1.205.084 1.838 1.236 1.838 1.236 1.07 1.835 2.809 1.305 3.495.998.108-.776.417-1.305.76-1.605-2.665-.3-5.466-1.332-5.466-5.93 0-1.31.465-2.38 1.235-3.22-.135-.303-.54-1.523.105-3.176 0 0 1.005-.322 3.3 1.23.96-.267 1.98-.399 3-.405 1.02.006 2.04.138 3 .405 2.28-1.552 3.285-1.23 3.285-1.23.645 1.653.24 2.873.12 3.176.765.84 1.23 1.91 1.23 3.22 0 4.61-2.805 5.625-5.475 5.92.42.36.81 1.096.81 2.22 0 1.606-.015 2.896-.015 3.286 0 .315.21.69.825.57C20.565 22.092 24 17.592 24 12.297c0-6.627-5.373-12-12-12"/></svg></a></li>
                    </ul>
                </nav>
            </div>
        </div>

    </footer>',
            'styles' => ':root {
            --footer-top-bg: #f8f9fa;
            --footer-top-text: #6c757d;
            --footer-top-heading: #343a40;
            --footer-top-link-hover: #0056b3;

            --footer-bottom-bg: #343a40;
            --footer-bottom-text: #adb5bd;
            --footer-bottom-link-hover: #ffffff;
        }

        /* Basic body styles for demonstration */
        footer {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            margin: 0;
            display: grid;
            grid-template-rows: 1fr auto;
        }

        .main-content {
            padding: 2rem;
        }

        /* FOOTER STYLES START HERE */

        .footer-twotier {
            color: var(--footer-top-text);
        }
        
        /* === TOP TIER STYLES === */
        .footer-twotier__top {
            background-color: var(--footer-top-bg);
            padding: 3rem 1.5rem;
        }

        .footer-twotier__top-container {
            max-width: 1140px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: 1fr; /* Mobile-first: single column */
            gap: 2rem;
        }

        .footer-twotier__brand p {
            margin: 1rem 0 0 0;
            font-size: 0.9rem;
            line-height: 1.6;
        }
        
        .footer-twotier__brand .logo {
            width: 150px;
            fill: var(--footer-top-heading);
        }

        .footer-twotier__heading {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--footer-top-heading);
            margin-top: 0;
            margin-bottom: 1rem;
        }

        .footer-twotier__links ul {
            margin: 0;
            padding: 0;
            list-style: none;
        }
        
        .footer-twotier__links li {
            margin-bottom: 0.75rem;
        }

        .footer-twotier__links a {
            color: var(--footer-top-text);
            text-decoration: none;
            transition: color 0.2s ease-in-out;
        }

        .footer-twotier__links a:hover {
            color: var(--footer-top-link-hover);
            text-decoration: underline;
        }

        /* === BOTTOM TIER STYLES === */
        .footer-twotier__bottom {
            background-color: var(--footer-bottom-bg);
            color: var(--footer-bottom-text);
            padding: 1.5rem;
        }
        
        .footer-twotier__bottom-container {
            max-width: 1140px;
            margin: 0 auto;
            display: flex;
            flex-direction: column; /* Mobile-first: stack */
            align-items: center;
            gap: 1rem;
            font-size: 0.875rem;
            text-align: center;
        }
        
        .footer-twotier__bottom a {
            color: var(--footer-bottom-text);
            text-decoration: none;
            transition: color 0.2s ease-in-out;
        }

        .footer-twotier__bottom a:hover {
            color: var(--footer-bottom-link-hover);
            text-decoration: underline;
        }

        .footer-twotier__copyright {
            margin: 0;
        }
        
        .footer-twotier__social ul {
            margin: 0;
            padding: 0;
            list-style: none;
            display: flex;
            gap: 1.5rem;
        }
        
        .footer-twotier__social a:hover {
            text-decoration: none;
        }
        
        .footer-twotier__social svg {
            width: 20px;
            height: 20px;
            fill: currentColor;
        }

        /* Media query for tablets and larger */
        @media (min-width: 768px) {
            .footer-twotier__top-container {
                grid-template-columns: 1.5fr 1fr 1fr; /* 3 columns on larger screens */
                gap: 3rem;
            }
            .footer-twotier__bottom-container {
                flex-direction: row; /* Arrange horizontally */
                justify-content: space-between;
                text-align: left;
            }
        }'
        ]);
    }
}
