import type { ElementProps, FloatingContext, ReferenceType } from '../types';
export interface Props {
    enabled?: boolean;
    keyboardOnly?: boolean;
}
/**
 * Adds focus event listeners that change the open state, like CSS :focus.
 * @see https://floating-ui.com/docs/useFocus
 */
export declare const useFocus: <RT extends ReferenceType = ReferenceType>({ open, onOpenChange, dataRef, events, refs, elements: { floating, domReference }, }: FloatingContext<RT>, { enabled, keyboardOnly }?: Props) => ElementProps;
