import { Block } from 'grapesjs';
import { ReactElement, JSX } from 'react';
import { PortalContainerResult } from './utils/react';
export type BlocksState = {
    /**
     * Array of blocks.
     */
    blocks: Block[];
    /**
     * Enable drag for a block.
     */
    dragStart: (block: Block, ev?: Event) => void;
    /**
     * Disable drag.
     */
    dragStop: (cancel?: boolean) => void;
    /**
     * Default Block Manager container.
     */
    Container: PortalContainerResult;
    /**
     * Map of blocks by category.
     */
    mapCategoryBlocks: MapCategoryBlocks;
};
export type BlocksResultProps = BlocksState;
export interface BlocksProviderProps {
    children: (props: BlocksResultProps) => ReactElement<any>;
}
export interface BlocksEventProps {
    blocks: Block[];
    container: HTMLElement;
    dragStart: (block: Block, ev?: Event) => void;
    drag: (ev: Event) => void;
    dragStop: (cancel?: boolean) => void;
}
export type MapCategoryBlocks = Map<string, Block[]>;
declare const _default: (props: BlocksProviderProps) => JSX.Element;
export default _default;
