import { ReactElement, JSX } from 'react';
export interface ModalState {
    /**
     * Modal title
     */
    title: ReactElement<any>;
    /**
     * Modal content
     */
    content: ReactElement<any>;
    /**
     * Modal attributes
     */
    attributes: Record<string, any>;
    /**
     * Callback for closing the modal
     */
    close: () => void;
}
export interface ModalResultProps extends ModalState {
    /**
     * Indicates if the modal is open.
     */
    open: boolean;
}
export interface ModalProviderProps {
    children: (props: ModalResultProps) => ReactElement<any>;
}
export interface ModalEventProps {
    open: boolean;
    title: string | HTMLElement;
    content: string | HTMLElement;
    attributes: Record<string, any>;
    close: () => void;
}
declare const _default: (props: ModalProviderProps) => JSX.Element;
export default _default;
