import { BlockProperties } from '../types';
import { AnimationComponentOptionsSchema } from './typesSchema';
export interface AnimationComponentOptions extends Omit<AnimationComponentOptionsSchema, 'block' | 'blockGroup' | 'animations'> {
    block?: Partial<BlockProperties> | false;
    blockGroup?: Partial<BlockProperties> | false;
    animations?: (props: {
        items: AnimationOption[];
    }) => AnimationOption[];
}
export declare enum AnimationStyleProperties {
    name = "animation-name",
    duration = "animation-duration",
    delay = "animation-delay",
    iterationCount = "animation-iteration-count",
    timingFunction = "animation-timing-function",
    fillMode = "animation-fill-mode"
}
export declare enum AnimationGroupStyleProperties {
    staggerDelay = "--stagger-delay"
}
export declare enum AnimationScrollStyleProperties {
    onScroll = "--animation-on-scroll",
    threshold = "--animation-threshold",
    repeat = "--animation-repeat"
}
export interface AnimationOption {
    id: string;
    name: string;
    css: string;
}
