import { SDKPluginOptions } from '../utils';
export interface CanvasAbsoluteModeOptions extends SDKPluginOptions {
    /**
     * Enable absolute mode globally. This will activate absolute drag mode for all components.
     * @default true
     */
    globalAbsolute?: boolean;
    /**
     * Custom function to determine whether an element should use absolute positioning mode.
     * This allows to define your own logic for enabling absolute mode, such as checking if
     * the element has `position: absolute` or matches a specific condition.
     *
     * This check is skipped if the `globalAbsolute` option is set to `true`.
     * @examples
     * enableAbsolute: ({ component }) => getComputedStyle(component.getEl()).position === 'absolute'
     */
    enableAbsolute?: '__fn__';
    /**
     * Enables grid-based snapping for absolute positioning.
     * Defines the snapping intervals in pixels along the x and y axes. When set, dragged elements
     * will align to the closest grid point.
     * @example
     * { x: 100, y: 50 } // will snap elements every 100px horizontally and 50px vertically.
     */
    snapping?: {
        x: number;
        y: number;
    };
    /**
     * Enables axis locking during element dragging.
     * When enabled, holding the Shift key while snapping to a nearby component locks movement to the matched axis (horizontal or vertical),
     * allowing for precise alignment based on distance indicators.
     * @example
     * { x: true, y: false }
     */
    locking?: {
        x: boolean;
        y: boolean;
    };
}
