import { ComponentDragEventProps, Canvas, Component, Editor } from 'grapesjs';
import { CanvasAbsoluteModeOptions } from './types';
export type GuideMatched = ComponentDragEventProps['guidesMatched'][number];
type CanvasView = ReturnType<Canvas['module']['getCanvasView']>;
export declare const isAbsolute: (editor: Editor, target: Component | Component[], opts: CanvasAbsoluteModeOptions) => {
    result: boolean;
    component: Component;
    dmode: import('grapesjs').DragMode | undefined;
} | undefined;
/**
 * This function calculates the distances between the origin and matched components.
 * - It returns the coordinates and dimensions of the bounding box for the matched components.
 * - In the case of a vertical guide, it'll return the height, and in the case of a horizontal guide, it'll return the width.
 * - It always returns the x and y coordinates where the distance guide should be placed.
 * - Important to note: canvasView.getElBoxRect is a method that returns the bounding box of an element already calculating the zoon, coordinates, offset, and other calculations.
 */
export declare function calculateOriginMatchedDistances({ guideMatched, canvasView }: {
    guideMatched: GuideMatched;
    canvasView: CanvasView;
}): {
    axis: string;
    x: number;
    y: number;
    width: number;
    height: number;
};
/**
 * This function handles the locked axis for the component.
 * - It calculates the new position of the component based on the guide and matched components.
 * - It uses the canvasView to get the bounding box of the elements and adjust their positions accordingly.
 * - It also updates the component's position based on the guide matched axis (x or y).
 * - It adds an offset to the top position to adjust the final position of the component.
 * - It returns the new position of the component.
 */
export declare function handleLockedAxis({ guideMatched, component, canvasView }: {
    guideMatched: GuideMatched;
    component: Component;
    canvasView: CanvasView;
}): void;
/**
 * This function handles the snapping of the component during drag events.
 * - It calculates the new position of the component based on the snapping options and the guides matched.
 * - It uses the canvasView to get the bounding box of the elements and adjust their positions accordingly.
 * - It also updates the component's last snapped position and guide matched properties.
 * - It returns the new position and the guide matched.
 */
export declare function handleSnappingDragMove({ snapping, editor, props }: {
    snapping: CanvasAbsoluteModeOptions['snapping'];
    props: ComponentDragEventProps;
    editor: Editor;
}): {
    x: number;
    y: number;
    guideMatched: any;
};
/**
 * This function handles the end of the snapping drag event.
 * - It updates the component's position based on the last snapped position.
 * - It removes the last snapped position and guide matched properties from the component.
 */
export declare function handleSnappingDragEnd({ snapping, props, editor }: {
    snapping: CanvasAbsoluteModeOptions['snapping'];
    props: ComponentDragEventProps;
    editor: Editor;
}): void;
export {};
