import { Editor, Component, ComponentView } from 'grapesjs';
import { SDKPluginOptions } from '../utils';
export interface CanvasEmptyStateOptions extends SDKPluginOptions {
    /**
     * Empty state types to render.
     * @examples
     * [
     *  {
     *    isValid: 'componentA',// check for valid componet type, as a string...
     *    isValid: ['componentA', 'componentB'], // ...as an array of component types...
     *    isValid: ({ component }) => component.is('componentA'), // ...or as a function
     *    // Render function to run when the component is empty
     *    render: ({ editor, component, mount, unmount }) => {
     *      const container = document.createElement('div');
     *      // ...
     *      window.addEventListener('someGlobalEvent', onSomeEvent);
     *      mount(container);
     *      // Clean up function
     *      return () => {
     *        unmount(container);
     *        window.removeEventListener('someGlobalEvent', onSomeEvent);
     *      }
     *    },
     *  }
     * ]
     */
    emptyStates?: EmptyStateProps[];
}
export interface EmptyStateProps {
    isValid: string | string[] | ((props: {
        component: Component;
        editor: Editor;
    }) => boolean);
    render: (props: EmptyStateRenderProps) => void | CleanUpFn;
}
type CleanUpFn = () => void;
interface EmptyStateRenderProps {
    editor: Editor;
    component: Component;
    componentView: ComponentView;
    mount: (el: HTMLElement) => void;
    unmount: (el: HTMLElement) => void;
}
export {};
