import { CanvasSpotProps, ResizerOptions } from 'grapesjs';
import { CanvasGridModeOptions as CanvasGridModeOptionsSchema } from './typesSchema';
import { Component } from '../types';
export interface CanvasGridModeOptions extends Omit<CanvasGridModeOptionsSchema, 'enableGrid' | 'itemResizable'> {
    enableGrid?: (props: {
        component: Component;
        parent: Component;
        isParentGrid?: boolean;
    }) => boolean;
    itemResizable?: boolean | ((props: {
        component: Component;
    }) => boolean | ResizerOptions);
}
export interface SpotGridDragProps extends CanvasSpotProps {
    spotEl?: HTMLElement;
}
