import { SDKPluginOptions } from '../utils';
export interface CanvasGridModeOptions extends SDKPluginOptions {
    /**
     * Provide a custom logic to enable the grid mode.
     * @examples
     * enableGrid: ({ component, isParentGrid }) => {
     *  if (isParentGrid && component.is('image')) {
     *   return true; // enable grid mode only for images
     *  }
     * }
     */
    enableGrid?: '__fn__';
    /**
     * Make grid items resizable when selected. Could also be a function for custom logic.
     * @default true
     * @examples
     * itemResizable: ({ component }) => {
     *    if (component.is('text')) {
     *     // Make the text component resizable only on the right and left sides.
     *     return { cr: true, cl: true };
     *    } else if (component.is('image')) {
     *     // Disable resizing for images
     *     return false;
     *    }
     *
     *    // Enable resizing for all other components
     *    return true;
     * }
     */
    itemResizable?: object;
    /**
     * Allow to edit grid properties in Style Manager.
     * @default false
     */
    styleableGrid?: boolean;
}
