import { Component, Editor } from '../types';
import { CanvasGridModeOptions, SpotGridDragProps } from './types';
export declare const COMMAND_DRAG_GRID = "component-grid-mode";
export declare const SPOT_TYPE_GRID = "grid-mode";
export declare const clsSpotGridDrag = "gjs-drag-grid-spot";
export declare const clsSpotGridDragCell = "gjs-drag-grid-spot__grid-item";
export declare const clsSpotGridDragTarget = "gjs-drag-grid-spot__grid-target";
export declare const clsSpotGridDragSnapped = "gjs-drag-grid-spot__snapped";
export declare const clsSpotGridDragContainer = "gjs-drag-grid-spot__container";
export declare const createDefaultSpotStyleEl: () => void;
export declare function onGridDragInit(props: {
    editor: Editor;
    component: Component | Component[];
    type: string;
}): {
    target: {
        component: Component;
        el: HTMLElement;
        offset: {
            top: number;
            left: number;
            width: number;
            height: number;
        };
        margin: {
            top: number;
            right: number;
            bottom: number;
            left: number;
        };
        computedStyles: CSSStyleDeclaration;
    };
    container: {
        component: Component;
        el: HTMLElement;
        offset: {
            top: number;
            left: number;
            width: number;
            height: number;
        };
        computedStyles: CSSStyleDeclaration;
        padding: {
            top: number;
            right: number;
            bottom: number;
            left: number;
        };
        columns: number[];
        rows: number[];
        gap: {
            column: number;
            row: number;
        };
    };
    startScroll: {
        top: number;
        left: number;
    };
    shadowContainerEl: HTMLDivElement;
    shadowSnappedEl: HTMLDivElement;
    shadowTargetEl: HTMLDivElement;
    spot: import('grapesjs').CanvasSpot<SpotGridDragProps>;
} | undefined;
export declare function onGridDragStart(props: {
    editor: Editor;
    shadowTargetEl: HTMLElement;
    shadowSnappedEl: HTMLElement;
    shadowContainerEl: HTMLElement;
    spotEl: HTMLElement | undefined;
    target: ReturnType<typeof getTarget>;
    container: ReturnType<typeof getContainer>;
}): void;
export declare function onGridDragEnd(props: {
    editor: Editor;
    shadowSnappedEl: HTMLElement;
    shadowContainerEl: HTMLElement;
    target: ReturnType<typeof getTarget>;
    cancelled?: boolean;
}): void;
export declare function setShadowCells(containerEl: HTMLElement, { rows, columns }: {
    rows: number[];
    columns: number[];
}): HTMLElement[][];
export declare function setShadowTargetStyle(el: HTMLElement, target: ReturnType<typeof getTarget>, container: ReturnType<typeof getContainer>): HTMLElement;
export declare function setShadowSnappedStyle(el: HTMLElement, target: ReturnType<typeof getTarget>): HTMLElement;
export declare function setShadowContainerStyle(el: HTMLElement, containerEl: HTMLElement): void;
export declare function findTarget(editor: Editor, target?: Component | Component[]): Component;
export declare function getTarget(editor: Editor, target?: Component | Component[]): {
    component: Component;
    el: HTMLElement;
    offset: {
        top: number;
        left: number;
        width: number;
        height: number;
    };
    margin: {
        top: number;
        right: number;
        bottom: number;
        left: number;
    };
    computedStyles: CSSStyleDeclaration;
};
export declare function getContainer(editor: Editor, target: Component): {
    component: Component;
    el: HTMLElement;
    offset: {
        top: number;
        left: number;
        width: number;
        height: number;
    };
    computedStyles: CSSStyleDeclaration;
    padding: {
        top: number;
        right: number;
        bottom: number;
        left: number;
    };
    columns: number[];
    rows: number[];
    gap: {
        column: number;
        row: number;
    };
};
export declare function getGridPosition(items: number[], start: number, minSize: number, gap: number, fraction?: number): number;
export declare function getWindowScroll(editor: Editor): {
    scroll: {
        top: number;
        left: number;
    };
};
export declare function shouldTerminate(editor: Editor, target: ReturnType<typeof getTarget>, container: ReturnType<typeof getContainer>, prop: string): boolean;
export declare function isGrid(editor: Editor, target?: Component | Component[], pluginOptions?: CanvasGridModeOptions): boolean;
export declare function findComponentInGrid(editor: Editor, target: Component, opts?: CanvasGridModeOptions): Component | undefined;
export declare function getGridItemArea(gridItemEl: HTMLElement, style?: CSSStyleDeclaration): {
    row: {
        start: number;
        end: number;
    };
    column: {
        start: number;
        end: number;
    };
    isComputed: boolean;
    raw: string;
};
