import { Operator } from '@studio/editor/src/components/DataConditionPicker/statementTypes';
import { DataCollectionResolverProps, DataVariableResolverProps, IDataSourceExporter } from '@studio/editor/src/typeConfigs/dataSources';
import { DataConditionResolverProps } from '@studio/editor/src/components/public/StudioDataConditionPicker';
export declare class HandlebarsExporter implements IDataSourceExporter {
    getHelperId(operator: Operator): string;
    getFullPath({ collectionId, path }: DataVariableResolverProps): string;
    getVariableSyntax({ dataResolver }: {
        dataResolver: DataVariableResolverProps;
    }): string;
    getCollectionStartSyntax({ dataResolver }: {
        dataResolver: DataCollectionResolverProps;
    }): string;
    getCollectionEndSyntax(): string;
    getConditionalStartSyntax({ dataResolver }: {
        dataResolver: DataConditionResolverProps;
    }): string;
    private _parseCondition;
    private getExpressionStr;
    private _parseValue;
    private _sanitizeVariableName;
    getConditionElseSyntax(): string;
    getConditionalEndSyntax(): string;
}
