import { SDKPluginOptions } from '../utils';
export interface DialogComponentOptions extends SDKPluginOptions {
    /**
     * Block options for the dialog component. See https://grapesjs.com/docs/api/block.html#properties for more information.
     * @example
     * { category: 'Extra', label: 'Popup' }
     */
    block?: object;
}
export interface DialogComponentProps {
    /**
     * Whether the dialog should close when pressing the X button.
     */
    closeWhenPressingX: boolean;
    /**
     * Whether the dialog should close when pressing the Escape key.
     */
    closeWhenPressingEsc: boolean;
    /**
     * Whether the dialog should open when leaving the window.
     */
    openWhenLeavingWindow: boolean;
    /**
     * Whether the dialog should open when scrolling to a specific level.
     * @example
     * '500'
     * @see https://developer.mozilla.org/en-US/docs/Web/API/Window/scrollY // TODO: ts-json-schema-generator is not able to generate this property
     */
    openWhenScrollingToLevel: string;
}
