import { BaseGoogleFontsAssetProviderOptions, BaseGoogleFontsSearchParams } from './typesSchema';
export interface GoogleFontsSearchParams extends BaseGoogleFontsSearchParams {
}
export interface GoogleFontFamily {
    category?: string | undefined;
    kind: string;
    family: string;
    subsets: string[];
    variants: string[];
    version: string;
    lastModified: string;
    files: {
        [variant: string]: string;
    };
    menu: string;
    axes: {
        tag: string;
        start: number;
        end: number;
    }[];
}
export interface GoogleFontsApiResponse {
    kind: string;
    items: GoogleFontFamily[];
}
export interface GoogleFontsAssetProviderOptions extends Omit<BaseGoogleFontsAssetProviderOptions, 'searchParams'> {
    /**
     * Override search params used for listing videos.
     */
    searchParams?: () => BaseGoogleFontsSearchParams;
}
