import { Messages } from 'grapesjs';
import { SDKPluginOptions } from '../utils';
/**
 * https://github.com/googleapis/google-api-nodejs-client/blob/788a3115084b1160b904eb70b1f54f48521ced2c/src/apis/webfonts/v1.ts#L298
 */
export interface BaseGoogleFontsSearchParams {
    /**
     * Auth client or API Key for the request
     */
    auth?: any;
    /**
     * V1 error format.
     */
    '$.xgafv'?: string;
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: string;
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Controls the font urls in `Webfont.files`, by default, static ttf fonts are sent.
     */
    capability?: string[];
    /**
     * Filters by Webfont.category, if category is found in Webfont.categories. If not set, returns all families.
     */
    category?: string;
    /**
     * Filters by Webfont.family, using literal match. If not set, returns all families
     */
    family?: string[];
    /**
     * Enables sorting of the list.
     */
    sort?: string;
    /**
     * Filters by Webfont.subset, if subset is found in Webfont.subsets. If not set, returns all families.
     */
    subset?: string;
}
export interface BaseGoogleFontsAssetProviderOptions extends SDKPluginOptions {
    /**
     * Google font API key. Get yours at https://console.cloud.google.com/
     */
    apiKey?: string;
    /**
     * Override search params used for the listing.
     */
    searchParams?: '__fn__';
    i18n?: Messages;
}
