import { BlockProperties, Component, Editor } from '../types';
import { IconifyComponentOptions as IconifyComponentOptionsSchema } from './typesSchema';
export interface IconifyComponentOptions extends Omit<IconifyComponentOptionsSchema, 'block'> {
    block?: Partial<BlockProperties> | false;
}
export interface IconifyCollection {
    prefix: string;
    icons: Record<string, {
        body: string;
    }>[];
    height: number;
    width: number;
}
export interface OpenIconPickerProps {
    collectionIds?: string[];
    editor: Editor;
    component: Component;
}
export interface IconPickerListProps {
    editor: Editor;
    handleClick: IconClickHandler;
    collectionId: string;
    collection: IconifyCollection;
    collectionFiltered?: IconifyCollection;
}
export interface IconPickerHeaderProps extends Omit<IconPickerListProps, 'collection' | 'collectionFiltered'> {
    collectionsList: Array<IconifyCollections & {
        id: string;
    }>;
}
export type IconifyCollections = Record<string, {
    category: string;
    name: string;
    total: number;
    height?: number;
    displayHeight?: number;
}>;
export type IconClickHandler = ({ icon, collectionId, iconId }: {
    icon: string;
    collectionId: string;
    iconId: string;
}) => void;
