import { SDKPluginOptions } from '../utils';
export interface IconifyComponentOptions extends SDKPluginOptions {
    /**
     * Additional Block properties of the component. Pass `false` to avoid adding the block.
     * @example
     * { category: 'Extra', label: 'My label' }
     */
    block?: 'Block';
    /**
     * List of icon collections to load.
     * @example ['mdi', 'fa-solid']
     */
    collections?: string[];
    /**
     * Extend the icon picker trait to the default icon component.
     * @default true
     */
    extendIconComponent?: boolean;
}
