import { LayoutCommandProps, LayoutConfig, RootLayoutConfig, StudioLayoutButtonConfigProps, StudioLayoutComponentsConfigProps, StudioLayoutSidebarLeftConfigProps } from '../types';
import { PluginWithInit } from '../utils';
import { LayoutSidebarButtonsOptions as LayoutSidebarButtonsOptionsSchema } from './typesSchema';
export interface LayoutSidebarButtonsOptions extends Omit<LayoutSidebarButtonsOptionsSchema, 'sidebarButton' | 'rootLayout' | 'sidebarButtons'> {
    /**
     * Customize each sidebar button.
     * @example
     * sidebarButton: ({ id, buttonProps, breakpoint, createSidebarButton }) => ({
     *  ...buttonProps,
     * // custom icon for panelBlocks button
     * icon: buttonProps.id === 'panelBlocks' ? '<svg ...>' : buttonProps.icon,
     * })
     */
    sidebarButton?: SidebarButtonFn;
    /**
     * Add or filter the resultant buttons per breakpoint.
     * @example
     * sidebarButtons: ({ breakpoint, sidebarButtons, createSidebarButton }) => {
     *  // Add a new button for the default layout
     *  return !breakpoint ? [...sidebarButtons, createSidebarButton({...})] : sidebarButtons;
     * }
     */
    sidebarButtons?: SidebarButtonsFn;
    /**
     * Customize the root layout per breakpoint.
     */
    rootLayout?: CustomRootLayoutFn;
    /**
     * Skip loading the layout config.
     * This might be useful if you're loading the layout config directly in the config.
     * @default false
     */
    skipLayoutConfig?: boolean;
}
export interface BreakpointProps extends Required<Pick<LayoutSidebarButtonsOptionsSchema, 'breakpointTablet' | 'breakpointMobile'>> {
}
export type SidebarButtonResult = StudioLayoutComponentsConfigProps | undefined | null | false;
export type CreateSidebarButtonFn = (props: SidebarButtonProps) => StudioLayoutButtonConfigProps;
export type SidebarButtonFn = (props: {
    id: string;
    buttonIds: typeof SidebarButtonIds;
    breakpoint: number;
    sidebarButtonProps: SidebarButtonProps;
    buttonProps: StudioLayoutButtonConfigProps;
    createSidebarButton: (props: Partial<SidebarButtonProps>) => StudioLayoutButtonConfigProps;
} & BreakpointProps) => SidebarButtonResult;
export type SidebarButtonsFn = (props: {
    buttonIds: typeof SidebarButtonIds;
    breakpoint: number;
    sidebarButtons: StudioLayoutComponentsConfigProps[];
    createSidebarButton: CreateSidebarButtonFn;
} & BreakpointProps) => SidebarButtonResult[];
export type CustomRootLayoutFn = (props: {
    breakpoint: number;
    sidebarButtons: StudioLayoutComponentsConfigProps[];
    rootLayout: RootLayoutConfig;
    layoutSidebarTarget: RootLayoutConfig;
    layoutSidebarLeft: StudioLayoutSidebarLeftConfigProps;
    createSidebarButton: CreateSidebarButtonFn;
} & BreakpointProps) => RootLayoutConfig;
export interface SidebarButtonProps {
    id: string;
    icon: string;
    label?: string;
    className?: string;
    layoutComponent: StudioLayoutComponentsConfigProps;
    layoutCommand?: Partial<Pick<LayoutCommandProps, 'style' | 'placer' | 'header'>>;
    tooltip?: string;
    skipSelfClose?: boolean;
    removeLayouts?: string[];
}
export declare enum SidebarButtonIds {
    panelBlocks = "panelBlocks",
    panelPagesLayers = "panelPagesLayers",
    panelGlobalStyles = "panelGlobalStyles",
    panelSidebarTabs = "panelSidebarTabs",
    panelAssets = "panelAssets"
}
export interface SDKPluginWithLayoutConfig extends PluginWithInit<LayoutSidebarButtonsOptions> {
    createLayoutConfig: (options?: Pick<LayoutSidebarButtonsOptions, 'sidebarButton' | 'sidebarButtons' | 'rootLayout'>) => LayoutConfig;
}
