import { SDKPluginOptions } from '../utils';
export interface LayoutSidebarButtonsOptions extends SDKPluginOptions {
    /**
     * Extend each sidebar button per breakpoint.
     * @examples
     * sidebarButton: ({ id, buttonProps, breakpoint, createSidebarButton }) => ({
     *   ...buttonProps,
     *   // custom icon for panelBlocks button
     *   icon: buttonProps.id === 'panelBlocks' ? '<svg ...>' : buttonProps.icon,
     * })
     */
    sidebarButton?: '__fn__';
    /**
     * Add or filter the resultant buttons per breakpoint.
     * @examples
     * sidebarButtons: ({ breakpoint, sidebarButtons, createSidebarButton }) => {
     *   // Add a new button for the default layout
     *   return !breakpoint ? [...sidebarButtons, createSidebarButton({...})] sidebarButtons;
     * }
     */
    sidebarButtons?: '__fn__';
    /**
     * Customize the resultant root layout per breakpoint.
     * @examples
     * rootLayout({ breakpoint, rootLayout, sidebarButtons, createSidebarButton }) {
     *  if (breakpoint === 768) {
     *    return {
     *      ...rootLayout,
     *      children: [
     *        { type: 'canvas' },
     *        { type: 'sidebarBottom', children: [ ...sidebarButtons, createSidebarButton({...}) ] }
     *      ]
     *    };
     *  }
     *  return rootLayout;
     * }
     */
    rootLayout?: '__fn__';
    /**
     * Custom tablet breakpoint.
     * @default 1024
     */
    breakpointTablet?: number;
    /**
     * Custom mobile breakpoint.
     * @default 768
     */
    breakpointMobile?: number;
}
