import { SDKPluginOptions } from '../utils';
export interface lightGalleryComponentOptions extends SDKPluginOptions {
    /**
     * Block options for the component. See https://grapesjs.com/docs/api/block.html#properties for more information.
     * @example
     * { category: 'Extra', label: 'My label' }
     */
    block?: object | false;
    /**
     * This plugin includes a commercial license when used within the Studio SDK.
     * If you're using it outside the SDK (core GrapesJS) in a commercial project, you must obtain a valid license separately.
     * Learn more about the lightGallery license key here: https://www.lightgalleryjs.com/license/
     */
    lgLicenseKey?: string;
    /**
     * SVG toolbar button icon for opening the gallery.
     * You can pass an empty string to avoid adding the toolbar button.
     * @example
     * '<svg viewBox="0 0 24 24"><path d="M12 9a3 3 0...'
     */
    toolbarIconOpen?: string;
    /**
     * Default source for the inner image component.
     * @default
     * 'https://placehold.co/200/777/white.png?text=Image'
     */
    defaultSrc?: string;
    /**
     * CDN scripts to load dynamically in case the library is not available.
     * @default
     * [
     *  'https://cdn.jsdelivr.net/npm/lightgallery@2.8.2/lightgallery.min.js',
     *  'https://cdn.jsdelivr.net/npm/lightgallery@2.8.2/plugins/thumbnail/lg-thumbnail.min.js',
     *  'https://cdn.jsdelivr.net/npm/lightgallery@2.8.2/plugins/video/lg-video.min.js',
     *  'https://cdn.jsdelivr.net/npm/lightgallery@2.8.2/plugins/autoplay/lg-autoplay.min.js',
     *  'https://cdn.jsdelivr.net/npm/lightgallery@2.8.2/plugins/zoom/lg-zoom.min.j'
     * ]
     */
    cdnScript?: string | string[];
    /**
     * CDN styles to load dynamically.
     * @default
     * 'https://cdn.jsdelivr.net/npm/lightgallery@2.8.2/css/lightgallery-bundle.min.css'
     */
    cdnStyle?: string | string[];
    /**
     * Plugins to include.
     * You have to ensure to load the required plugins in the `cdnScript` option.
     * Check the list of available plugins here: https://www.lightgalleryjs.com/docs/getting-started/#plugins
     * @default
     * ['lgThumbnail', 'lgVideo', 'lgAutoplay', 'lgZoom']
     */
    plugins?: string[];
}
export interface ComponentWindow extends Window {
    lightGallery?: (...args: any) => any;
}
