import { BlockProperties, CanvasSpotProps, DeviceProperties } from 'grapesjs';
import { PresetPrintableOptions as PresetPrintableOptionsSchema } from './typesSchema';
export interface PresetPrintableOptions extends Omit<PresetPrintableOptionsSchema, 'blockPageBreak' | 'devices'> {
    blockPageBreak?: Partial<BlockProperties> | false;
    devices?: (props: {
        items: CreateDevicePrintableProps[];
    }) => CreateDevicePrintableProps[];
}
export interface DevicePrintableProps extends DeviceProperties {
    minHeight?: string;
    sizeH?: number;
    sizeW?: number;
    sizeUnit?: string;
}
export interface CreateDevicePrintableProps {
    name: string;
    width: number;
    height: number;
    unit: string;
    id?: string;
}
export interface SpotPageBreaksProps extends CanvasSpotProps {
    pageBreaks?: number[];
    spotEl?: HTMLElement;
    up?: number;
}
export declare enum CommandsPresetPrintable {
    print = "presetPrintable:print"
}
