import { SDKPluginOptions } from '../utils';
export interface PresetPrintableOptions extends SDKPluginOptions {
    /**
     * Additional Block properties of the page break component. Pass `false` to avoid adding the block.
     * @example
     * { category: 'Extra', label: 'My label' }
     */
    blockPageBreak?: 'Block';
    /**
     * With this option enabled the document won't grow in height and it won't be possible to scroll.
     * @default false
     */
    fixedHeight?: boolean;
    /**
     * Customize the printable devices.
     * @examples
     * devices: ({ items }) => {
     *  return [
     *    ...items,
     *    {
     *      id: 'custom',
     *      name: 'Custom',
     *      width: 100,
     *      height: 200,
     *      unit: 'mm'
     *   }
     *  ]
     * }
     */
    devices?: '__fn__';
    /**
     * Selected device id.
     * Available printable sizes: 'a5', 'a5-portrait', 'a4', 'a3', 'b5', 'b4', 'letter', 'legal', 'ledger'.
     * @default "a4"
     */
    selectedDevice?: string;
    /**
     * Enables the page break indicators in the canvas.
     * @default true
     */
    enablePageBreaksSpot?: boolean;
}
export interface CommandsPresetPrintableOptions {
    /**
     * Print all pages.
     * @default false
     */
    allPages?: boolean;
    /**
     * If true, each page will be printed separately.
     * @default false
     */
    separatePrints?: boolean;
}
