import { Mark, MarkSpec, Node, NodeSpec, Schema } from 'prosemirror-model';
export declare const keyAttrInlineFragment = "data-gs-ifrg";
export declare const AllAttrKey = "attrs";
export declare const allAttrsToDom: (node: Mark | Node) => any;
export declare const nodes: {
    nonTextNode: {
        group: string;
        content: string;
        attrs: {
            tagName: {
                default: string;
            };
            attrs: {
                default: {};
            };
        };
        parseDOM: {
            tag: string;
            getAttrs: (dom: HTMLElement) => {
                tagName: string;
                attrs: Readonly<Record<string, string | null>>;
            };
            priority: number;
        }[];
        toDOM(node: Node): [any, any, number];
    };
    table: NodeSpec;
    table_row: NodeSpec;
    table_cell: NodeSpec;
    table_header: NodeSpec;
    doc: {
        content: string;
    };
    text: {
        group: string;
        inline: true;
    };
    inlineFragment: {
        group: string;
        content: string;
        isTextBlock: boolean;
        parseDOM: {
            tag: string;
            getAttrs: (dom: HTMLElement) => {
                attrs: Readonly<Record<string, string | null>>;
            };
        }[];
        toDOM: () => [string, {
            "data-gs-ifrg": string;
        }, number];
    };
    div: {
        group: string;
        content: string;
        attrs: {
            [name: string]: import('prosemirror-model').AttributeSpec;
        };
        parseDOM: {
            tag: string;
            getAttrs: (dom: HTMLElement) => {
                attrs: Readonly<Record<string, string | null>>;
            };
        }[];
        toDOM: (node: Node) => [string, any, number];
    };
    paragraph: {
        group: string;
        content: string;
        attrs: {
            [name: string]: import('prosemirror-model').AttributeSpec;
        };
        parseDOM: {
            tag: string;
            getAttrs: (dom: HTMLElement) => {
                attrs: Readonly<Record<string, string | null>>;
            };
        }[];
        toDOM: (node: Node) => [string, any, number];
    };
    orderedList: {
        group: string;
        content: string;
        attrs: {
            [name: string]: import('prosemirror-model').AttributeSpec;
        };
        parseDOM: {
            tag: string;
            getAttrs: (dom: HTMLElement) => {
                attrs: Readonly<Record<string, string | null>>;
            };
        }[];
        toDOM: (node: Node) => [string, any, number];
    };
    bulletList: {
        group: string;
        content: string;
        attrs: {
            [name: string]: import('prosemirror-model').AttributeSpec;
        };
        parseDOM: {
            tag: string;
            getAttrs: (dom: HTMLElement) => {
                attrs: Readonly<Record<string, string | null>>;
            };
        }[];
        toDOM: (node: Node) => [string, any, number];
    };
    listItem: {
        content: string;
        group: string;
        attrs: {
            [name: string]: import('prosemirror-model').AttributeSpec;
        };
        parseDOM: {
            tag: string;
            getAttrs: (dom: HTMLElement) => {
                attrs: Readonly<Record<string, string | null>>;
            };
        }[];
        toDOM: (node: Node) => [string, any, number];
        defining: true;
    };
    codeBlock: {
        group: string;
        content: string;
        marks: string;
        attrs: {
            [name: string]: import('prosemirror-model').AttributeSpec;
        };
        parseDOM: {
            tag: string;
            getAttrs: (dom: HTMLElement) => {
                attrs: Readonly<Record<string, string | null>>;
            };
        }[];
        toDOM: (node: Node) => [string, any, (string | number)[]];
    };
    image: {
        inline: true;
        group: string;
        selectable: true;
        attrs: {
            [name: string]: import('prosemirror-model').AttributeSpec;
        };
        parseDOM: {
            tag: string;
            getAttrs: (dom: HTMLElement) => {
                attrs: Readonly<Record<string, string | null>>;
            };
        }[];
        toDOM: (node: Node) => [string, any];
    };
    inlineBreak: {
        inline: true;
        group: string;
        selectable: false;
        parseDOM: {
            tag: string;
        }[];
        toDOM(): [string, {
            "data-gs-ib": string;
        }];
    };
    hardBreak: {
        inline: false;
        group: string;
        selectable: false;
        attrs: {
            [name: string]: import('prosemirror-model').AttributeSpec;
        };
        parseDOM: {
            tag: string;
            getAttrs: (dom: HTMLElement) => {
                attrs: Readonly<Record<string, string | null>>;
            };
        }[];
        toDOM: (node: Node) => [string, any];
    };
    heading: {
        group: string;
        content: string;
        attrs: {
            level: {
                default: number;
            };
            attrs: {
                default: {};
            };
        };
        defining: true;
        parseDOM: {
            tag: string;
            getAttrs: (dom: HTMLElement) => {
                level: number;
                attrs: Readonly<Record<string, string | null>>;
            };
        }[];
        toDOM({ attrs }: Node): [string, any, number];
    };
};
export declare const marks: {
    strong: MarkSpec;
    link: MarkSpec;
    em: MarkSpec;
    underline: MarkSpec;
    strikethrough: MarkSpec;
    font_size: {
        attrs: {
            size: {
                default: null;
            };
        };
        parseDOM: {
            tag: string;
            getAttrs: (dom: HTMLElement) => {
                size: string;
                attrs: string;
            };
        }[];
        toDOM(mark: Mark): [string, any, number];
    };
};
export declare const schema: Schema<"div" | "table" | "image" | "text" | "heading" | "doc" | "inlineFragment" | "paragraph" | "orderedList" | "bulletList" | "listItem" | "codeBlock" | "inlineBreak" | "hardBreak" | "table_row" | "table_cell" | "table_header" | "nonTextNode", "em" | "link" | "strong" | "underline" | "strikethrough" | "font_size">;
export type DefaultSchema = typeof schema;
export default schema;
