import { RteCustomToolbarProps } from '@studio/editor/src/types';
import { EditorView } from 'prosemirror-view';
import { RteProseMirrorOptions } from './types';
export interface HTMLElementWithView extends HTMLElement {
    __rteView: EditorView;
}
export declare const eventRteSelectionChange = "rte:selectionchange";
export declare enum ToolbarCommands {
    bold = "bold",
    italic = "italic",
    underline = "underline",
    strikethrough = "strikethrough",
    link = "link",
    image = "image",
    alignText = "alignText",
    heading = "heading",
    fontSize = "fontSize",
    listBullet = "listBullet",
    listOrdered = "listOrdered"
}
export declare const toolbarIcons: {
    bold: string;
    italic: string;
    underline: string;
    strikethrough: string;
    link: string;
    image: string;
    listBullet: string;
    listOrdered: string;
    alignTextLeft: string;
    alignTextCenter: string;
    alignTextRight: string;
    alignTextJustify: string;
};
export declare const getToolbarItems: (props: RteCustomToolbarProps, opts: RteProseMirrorOptions) => import('@studio/editor/src/types').RteCustomToolbarResult;
export default getToolbarItems;
