import { WithEditorProps } from '@studio/editor/src/typeConfigs/common';
import { StudioLayoutComponentsConfigProps } from '@studio/editor/src/typeConfigs/layoutComponents';
import { RteCustomToolbarProps, RteCustomToolbarResult } from '@studio/editor/src/typeConfigs/rte';
import { Schema } from 'prosemirror-model';
import { Plugin } from 'prosemirror-state';
import { EditorView } from 'prosemirror-view';
import { SDKPluginOptions } from '../utils';
import { BuiltInCommands } from './commands';
import { DefaultSchema } from './schema';
import { ComponentView } from 'grapesjs';
export type { DefaultSchema } from './schema';
export { StudioCommands } from '@studio/editor/src/plugins/global/types';
export type { LayoutCommandProps, RteCustomToolbar } from '@studio/editor/src/types';
export interface CustomRteOptions extends RteCustomToolbarProps {
    event?: PointerEvent;
    view: ComponentView;
}
export interface RteProseMirrorToolbarProps extends RteCustomToolbarProps {
    /**
     * Default toolbar items.
     */
    items: StudioLayoutComponentsConfigProps[];
    /**
     * Built-in commands.
     */
    commands: BuiltInCommands;
    /**
     * Built-in toolbar layout components.
     */
    layouts: Record<string, StudioLayoutComponentsConfigProps>;
    /**
     * ProseMirror instance.
     */
    proseMirror: {
        view: EditorView;
    };
}
export interface RteProseMirrorOptions extends SDKPluginOptions {
    /**
     * Enable RTE on click of the text component, instead of the default double-click.
     * @default false
     */
    enableOnClick?: boolean;
    /**
     * Extend the default ProseMirror schema.
     * @example
     * ({ schema }) => {
     *  // add additional nodes and return a new schema
     *  return new Schema({
     *    nodes: schema.spec.nodes.append({...}),
     *    marks: schema.spec.marks
     *  });
     * }
     */
    schema?: (props: WithEditorProps & {
        schema: DefaultSchema;
    }) => Schema;
    /**
     * Pass additional ProseMirror plugins.
     * @example
     * ({ plugins }) => [
     *    // use the default plugins
     *    ...plugins,
     *    // pass your plugins
     *  ]
     */
    plugins?: (props: WithEditorProps & {
        plugins: Plugin[];
        Plugin: typeof Plugin;
    }) => Plugin[];
    /**
     * Customize the toolbar items.
     * @example
     * toolbar({ items, component, proseMirror }) {
     *    const { view } = proseMirror;
     *    return [
     *      // use the default toolbar items
     *      ...items,
     *      {
     *        id: 'customButton',
     *        type: 'button',
     *        icon: 'flare',
     *        onClick: () => {...}
     *      }
     *    ];
     *  }
     */
    toolbar?: (props: RteProseMirrorToolbarProps) => RteCustomToolbarResult;
}
