import { Component, ComponentDefinitionDefined, Editor, ObjectAny } from 'grapesjs';
export interface ComponentConfig {
    component: React.ComponentType<any>;
    props?: () => Array<{
        type: string;
        name: string;
        label: string;
        value: any;
    }>;
    model?: ComponentDefinitionDefined;
    editorRender?: (props: {
        props: any;
        children: React.ReactNode;
        editor: Editor;
        component: Component;
        connectDom: (element: HTMLElement) => void;
    }) => React.ReactElement;
}
export interface ErrorParams {
    noPagesFound: ObjectAny;
    pageNotFound: {
        pageId?: string;
    };
    noFramesFound: ObjectAny;
    missingRootComponent: ObjectAny;
    componentNotFound: {
        componentId: string;
    };
}
export type ErrorHandler<T extends keyof ErrorParams> = React.ReactNode | ((params: ErrorParams[T]) => React.ReactNode);
export type ErrorRenderers = {
    [K in keyof ErrorParams]?: ErrorHandler<K>;
};
export interface WrapperProps {
    children?: React.ReactNode;
    editorProps?: {
        doc: Document;
        editor: unknown;
        frameView: unknown;
    };
}
export interface CustomRendererReactConfig {
    components?: {
        [key: string]: ComponentConfig;
    };
    errors?: ErrorRenderers;
    wrapper?: React.ComponentType<WrapperProps>;
    skipDocType?: boolean;
}
