import { ComponentView, Editor } from '../types';
import { CustomRteOptions, EditorDataTinyMCE, EditorTinyMCE, RawEditorOptions, RteTinyMceOptions } from './types';
export declare const mapElToRteData: WeakMap<HTMLElement, EditorDataTinyMCE>;
export declare const setElToRteData: (el: HTMLElement, data: EditorDataTinyMCE) => void;
export declare const deleteElToRteData: (el: HTMLElement) => void;
export declare const getRteDataFromEl: (el: HTMLElement) => EditorDataTinyMCE | undefined;
export declare const preventRteBlur: (ev: MouseEvent) => void;
export declare const preventDrag: (ev: DragEvent) => void;
export declare const focusCursor: (rteEditor: EditorTinyMCE, opts?: CustomRteOptions) => void;
export declare const loadConfig: (props: {
    el: HTMLElement;
    componentView: ComponentView;
    editor: Editor;
    pluginOpts?: RteTinyMceOptions;
}) => RawEditorOptions;
export declare const loadScripts: (src: string | string[], doc?: Document) => Promise<void>;
