import { SDKPluginOptions } from '../utils';
export interface SwiperComponentOptions extends SDKPluginOptions {
    /**
     * Additional Block properties of the component. Pass `false` to avoid adding the block.
     * @example
     * { category: 'Extra', label: 'My label' }
     */
    block?: 'Block';
    /**
     * CDN scripts to load dynamically in case the library is not available.
     * @default "https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"
     */
    cdnScript?: string;
    /**
     * CDN styles to load dynamically.
     * @default "https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"
     */
    cdnStyle?: string;
}
