import { Component, Editor, Plugin, SdkPlanCategories, Trait, TraitProperties } from './types';
export { SdkPlanCategories } from './types';
/**
 * Interface for the options of a plugin.
 */
export interface SDKPluginOptions {
    /**
     * The license key for the plugin.
     * This is optional, only required if the plugin is used outside of Studio SDK.
     * @example
     * 'your-license-key'
     */
    licenseKey?: string;
}
export interface StudioPluginTraitProperties extends TraitProperties {
    tip?: string;
    labelToTitle?: boolean;
    subTraits?: Record<string, StudioPluginTraitProperties[]>;
    visible?: (props: {
        component: Component;
        trait: Trait;
    }) => boolean;
}
export type StudioPluginTraits = Record<string, Partial<StudioPluginTraitProperties>>;
export interface SDKPlugin<T extends SDKPluginOptions = SDKPluginOptions> extends Plugin<T> {
}
export interface PluginWithInit<T extends SDKPluginOptions = SDKPluginOptions> extends Plugin<T> {
    init: (opts: T) => (editor: Editor) => void;
}
export declare const pluginWithInit: <T extends SDKPluginOptions>(plugin: SDKPlugin<T>) => PluginWithInit<T>;
export declare function subscribeToLicenseCheck({ editor, plan, pluginName, licenseKey, cleanup }: {
    editor: Editor;
    pluginName: string;
    plan: SdkPlanCategories;
    licenseKey?: string;
    cleanup: () => void;
}): Promise<void>;
export declare const elHasAttribute: (el: HTMLElement, attrName: string) => boolean;
export declare const elHasClassName: (el: HTMLElement, className: string) => boolean;
export declare const isComponentByTypeKey: (type: string) => (el: Element) => boolean;
export declare const isComponentTypeSource: (...types: string[]) => (source: Component) => boolean;
export declare const isComponentTypeTarget: (...types: string[]) => (_: Component, target: Component) => boolean;
/**
 *  A helper function to get props, value and trait defintion from StudioPluginTraits.
 */
export declare const getSetupDataFromTraits: (traitProps: StudioPluginTraits, opts?: {
    category?: StudioPluginTraitProperties["category"];
}) => {
    propKeys: string[];
    propsNoValues: string[];
    props: Record<string, any>;
    traits: StudioPluginTraitProperties[];
};
/**
 * A helper function to initialize the traits of a plugin.
 */
export declare const initSdkPluginTraits: (cmp: Component, traits: StudioPluginTraitProperties[]) => void;
export declare const updateSubTraits: (cmp: Component, traitId: string) => void;
export declare const appendStyleLink: (styles: string[], doc?: Document) => void;
export declare const appendStyle: (id: string, css: string, opts: {
    doc?: Document;
    target?: HTMLElement;
}) => void;
/**
 * This function allows to move props from kebab-case to camelCase.
 * It's useful when props are added via HTML attributes (eg. data-gjs-my-prop="value") but
 * the component has the camelCase format (eg. myProp).
 *
 * This function should be usually called on model.init of the component.
 */
export declare const moveKebabPropsToCamelCase: (cmp: Component, camelProps: string[]) => void;
export declare const CLS_PREFIX = "gjs-plg-";
export declare const DATA_ATTR_PLG = "data-gs-plg-";
export declare const TYPE_KEY_ATTR = "data-type-role";
