import { BaseYoutubeAssetProviderOptions, BaseYoutubeSearchParams } from './typesSchema';
/**
 * https://github.com/googleapis/google-api-nodejs-client/blob/f4848c7295f887ae311c93967ee4723e336f263c/src/apis/youtube/v3.ts#L11315
 */
export interface YoutubeSearchParams extends BaseYoutubeSearchParams {
}
export interface YoutubeVideoSnippet {
    id: {
        kind: string;
        videoId: string;
    };
    snippet: {
        title: string;
        thumbnails: {
            default: {
                url: string;
                width: number;
                height: number;
            };
            medium: {
                url: string;
                width: number;
                height: number;
            };
            high: {
                url: string;
                width: number;
                height: number;
            };
            standard?: {
                url: string;
                width: number;
                height: number;
            };
            maxres?: {
                url: string;
                width: number;
                height: number;
            };
        };
    };
}
export interface YoutubeApiResponse {
    items: YoutubeVideoSnippet[];
    nextPageToken?: string;
    prevPageToken?: string;
}
export interface YoutubeAssetProviderOptions extends Omit<BaseYoutubeAssetProviderOptions, 'searchParams'> {
    /**
     * Override search params used for listing videos.
     */
    searchParams?: (props: {
        searchValue: string;
    }) => BaseYoutubeSearchParams;
}
