/// <reference types="react" />
import { IconProps } from '@mdi/react/dist/IconProps';
import { IconNames, StudioIconProps } from '../public/StudioIcon';
export declare interface ButtonProps extends React.ButtonHTMLAttributes<HTMLButtonElement> {
    variant?: 'pr' | 'out' | 'out-clear' | 'warn' | 'danger';
    size?: '' | 'xs' | 's' | 'm' | 'm2' | 'lg';
    active?: boolean;
    disabled?: boolean;
    border?: boolean;
    rounded?: boolean;
    tooltip?: React.ReactNode;
    full?: boolean;
    block?: boolean;
    icon?: string | (Omit<IconProps, 'path' | 'size'> & {
        icon?: string | `${IconNames}` | IconNames;
        size?: StudioIconProps['size'];
    });
    loading?: boolean;
    withBg?: boolean;
}
export declare const getClsFromProps: ({ variant, size, className, active, border, rounded, disabled, withBg, block, full }: ButtonProps) => (string | false | undefined)[];
export default function Button({ children, ...props }: ButtonProps): import("react/jsx-runtime").JSX.Element;
