import type { CustomRTE as CustomRTEConfig } from 'grapesjs';
import React from 'react';
import { RteCustomToolbarResult } from '../../types';
import { PortalContainerResult } from './utils';
interface RtePropsResult {
    /**
     * Indicates if the RTE is enabled.
     */
    enabled: boolean;
    /**
     * RTE actions
     */
    actions: ActionRTE[];
    /**
     * Default RTE container.
     */
    Container: PortalContainerResult;
    customRte?: CustomRTEConfig;
    customToolbar?: RteCustomToolbarResult;
}
interface CustomRTEProps {
    children: (props: Omit<RtePropsResult, 'Container'>) => React.ReactElement;
}
interface ActionRTE {
    id: string;
    icon: string;
    state: number;
    run: () => void;
}
export default function CustomRTE({ children }: CustomRTEProps): import("react/jsx-runtime").JSX.Element | null;
export {};
