export type UnitOption = string | {
    id: string;
    label: string;
};
export type ValidUnit = (unit: string, units: UnitOption[], opts?: {
    partial?: boolean;
}) => boolean;
export type NumericProp = string | number;
export interface MinMaxStepProps {
    min?: NumericProp;
    max?: NumericProp;
    step?: NumericProp;
}
export interface ValueWithMinMaxStepProps extends MinMaxStepProps {
    value: NumericProp;
}
export declare const parseNumberUnit: (value: string) => {
    number: string;
    unit: string;
};
export declare const fixDecimals: ({ value, step }: ValueWithMinMaxStepProps) => number;
export declare const getValueUpDown: ({ value, key, shiftKey, min, max, step }: ValueWithMinMaxStepProps & {
    key: string;
    shiftKey?: boolean | undefined;
}) => number | null;
export declare const getMinMaxValue: ({ min, max, value }: ValueWithMinMaxStepProps) => string;
/**
 * Start pan number value
 * @param initialValue Initial value
 * @param clientX Client X position
 * @param update Update function which triggers on each new value
 */
export declare const panNumberValue: (initialValue: number | string, startValue: number, update: (value: number, partial?: boolean) => void, options?: MinMaxStepProps) => void;
/**
 * Check if the unit is valid (has a reference in passed `units`).
 */
export declare const isValidUnit: ValidUnit;
