import type { Property, PropertyNumber, PropertySelect, Sector } from 'grapesjs';
import { ElementType, ReactNode } from 'react';
import { Option } from '../ButtonGroupField';
type PropertyStack = any;
type LabelOptions = Record<string, any>;
export interface SectorProps extends React.HTMLProps<HTMLDivElement> {
    sector: Sector;
}
export declare const getSectorClass: (open?: boolean, index?: number, isLast?: boolean) => string;
export declare const getOptions: (prop: PropertySelect, labelOpts?: LabelOptions) => {
    id: string;
    label: string;
    title: string | undefined;
}[];
export declare const toOptionsWithTitle: (prop: PropertySelect, options: Option[]) => {
    title: string;
    id: string;
    icon?: string | undefined;
    label?: ReactNode;
}[];
export declare const getButtonsProps: (prop: PropertySelect, labelOpts?: LabelOptions) => {
    size: "s";
    options: {
        id: string;
        label: string;
        title: string | undefined;
    }[];
    value: any;
    onChange: (value: string) => PropertySelect;
};
export declare const getSelectFontProps: (prop: PropertySelect) => {
    size: "s";
    options: undefined;
    value: any;
    onChange: (value: string) => PropertySelect;
    buttonClassName: string;
    labelAs: ElementType;
    label: import("react/jsx-runtime").JSX.Element;
};
export declare const getStackProps: (prop: PropertyStack, newLayer?: {}) => {
    title: any;
    titleAdd: string;
    items: any;
    selected: any;
    renderItem: (layer: any) => any;
    add: () => any;
    select: (layer: any) => any;
    remove: (layer: any) => any;
    move: (layer: any, index?: number) => any;
    label: import("react/jsx-runtime").JSX.Element;
};
export declare const getNumberProps: (prop: PropertyNumber) => {
    size: "s";
    value: any;
    valueUnit: string;
    units: string[];
    min: number;
    max: number | undefined;
    step: number;
    placeholder: string;
    onChangeUnit: (unit: string) => PropertyNumber;
    onChange: (value: string, partial: boolean) => PropertyNumber;
};
export declare const getColorProps: (prop: Property) => {
    size: "s";
    value: any;
    placeholder: string;
    onChange: (value: string, partial: boolean) => Property<import("grapesjs").PropertyPropsCustom>;
};
export declare const getFileProps: (prop: Property) => {
    onOpen(): void;
    size: "s";
    value: any;
    placeholder: string;
    onChange: (value: string, partial: boolean) => Property<import("grapesjs").PropertyPropsCustom>;
};
export declare const isPropertyVisible: (prop?: Property) => boolean;
declare const StyleManager: import("react").FunctionComponent<import("react").HTMLProps<HTMLDivElement> & import("@grapesjs/react/dist/StylesProvider").StylesState>;
export default StyleManager;
