import type { ButtonProps } from '../Button';
import type { ReactNode } from 'react';
export declare enum ToastVariant {
    Info = "info",
    Error = "error",
    Success = "success",
    Warning = "warning"
}
export interface IToast {
    id: string;
    uuid?: string;
    header: ReactNode;
    content?: ReactNode;
    variant?: ToastVariant;
    autoHideTimeout?: number;
    buttons?: (ButtonProps & {
        id: string;
    })[];
    onDismiss?: (id: string) => void;
}
