import type { Editor } from 'grapesjs';
import { MouseEvent, ReactNode } from 'react';
import { ButtonWithTooltipProps } from '../Button/ButtonWithTooltip';
import type { CommonStudioLayoutConfigProps, CommonStudioLayoutProps } from './types';
import type { StudioLayoutButtonConfig } from './types/StudioButtonSchema';
export { StudioButtonSize, StudioButtonVariant } from '../public/types/StudioButtonSchema';
interface ButtonActionProps {
    editor: Editor;
    state: StudioButtonState;
    setState: (props: StudioButtonState) => void;
}
export interface StudioLayoutButtonConfigProps extends CommonStudioLayoutConfigProps<StudioButtonProps, StudioLayoutButtonConfig> {
}
export interface StudioButtonProps<T = HTMLButtonElement> extends Omit<CommonStudioLayoutProps<StudioLayoutButtonConfig, T>, 'label' | 'icon' | 'editorEvents' | 'onClick' | 'htmlAttrs'> {
    label?: ReactNode | ((props: {
        editor?: Editor;
    }) => ReactNode);
    icon?: ButtonWithTooltipProps['icon'];
    editorEvents?: Record<string, (props: ButtonActionProps & {
        fromEvent: Record<string, any>;
    }) => void>;
    onClick?: (props: ButtonActionProps & {
        event: MouseEvent<HTMLButtonElement>;
    }) => void;
}
export interface StudioButtonState extends Partial<Pick<StudioButtonProps, 'variant' | 'className' | 'tooltip' | 'label' | 'icon' | 'active' | 'size' | 'disabled'>> {
}
export declare const StudioButton: import("react").NamedExoticComponent<StudioButtonProps<HTMLButtonElement>>;
export default StudioButton;
