/// <reference types="react" />
import type { EditorProps } from '@monaco-editor/react';
import type { CommonStudioLayoutConfigProps, CommonStudioLayoutFieldProps, CommonStudioLayoutFieldStateKeys, WithEditorEvents, WithEditorState } from './types';
import type { StudioLayoutCodeFieldConfig } from './types/StudioCodeFieldSchema';
export interface StudioLayoutCodeFieldConfigProps extends CommonStudioLayoutConfigProps<StudioCodeFieldProps, StudioLayoutCodeFieldConfig> {
}
export interface StudioCodeFieldState extends Pick<StudioCodeFieldProps, CommonStudioLayoutFieldStateKeys | 'language' | 'row' | 'minHeight'> {
}
export interface StudioCodeFieldProps extends Omit<CommonStudioLayoutFieldProps<StudioLayoutCodeFieldConfig, StudioCodeFieldStateHandler>, 'monacoOptions'>, WithEditorEvents<StudioCodeFieldState> {
    monacoOptions?: Partial<EditorProps['options']>;
}
interface StudioCodeFieldStateHandler extends WithEditorState<StudioCodeFieldState> {
    value: string;
}
export declare const StudioCodeField: import("react").FunctionComponent<StudioCodeFieldProps>;
export default StudioCodeField;
