/// <reference types="react" />
import type { CommonStudioLayoutConfigProps, WithEditorEvents, WithEditorState } from './types';
import type { StudioLayoutInputFieldConfig } from './types/StudioInputFieldSchema';
export interface StudioLayoutInputFieldConfigProps extends CommonStudioLayoutConfigProps<StudioInputFieldProps, StudioLayoutInputFieldConfig> {
}
export interface StudioInputFieldProps extends Omit<StudioLayoutInputFieldConfig, 'type' | 'label' | 'style' | 'onChange' | 'onInput' | 'editorEvents'>, WithEditorEvents<StudioInputFieldState> {
    label?: React.ReactNode;
    style?: React.CSSProperties;
    onChange?(props: StudioInputFieldStateHandler): void;
    onInput?(props: StudioInputFieldStateHandler): void;
}
export interface StudioInputFieldState extends Partial<Pick<StudioInputFieldProps, 'className' | 'style' | 'label' | 'name' | 'value' | 'size' | 'disabled' | 'required' | 'readOnly' | 'placeholder'>> {
}
interface StudioInputFieldStateHandler extends WithEditorState<StudioInputFieldState> {
    value: string;
}
export declare const StudioInputField: import("react").NamedExoticComponent<StudioInputFieldProps>;
export default StudioInputField;
