import { StudioLayouts } from '.';
import { DataVariableResolverProps } from '../../DataVariablePicker';
import type { StudioLayoutBasePropsConfig } from './StudioBaseSchema';
export interface StudioLayoutDataCollectionPickerConfig extends StudioLayoutBasePropsConfig {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.panelDataCollectionPicker}`;
    /**
     * Data collection component.
     */
    component: object;
    /**
     * Callback function to be called when the picker selection is confirmed.
     * @examples ({ value }) => console.log('new value', value);
     */
    onConfirm?: '__fn__';
}
export interface DataCollectionResolverProps {
    collectionId?: string;
    startIndex?: number;
    endIndex?: number;
    dataSource?: DataVariableResolverProps;
}
