import { StudioLayouts } from '.';
import type { StudioLayoutPanelConfig } from './StudioPanelSchema';
export interface StudioLayoutPanelBlocksConfig extends StudioLayoutPanelConfig {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.panelBlocks}`;
    /**
     * Whether to show symbols.
     * @default true
     */
    symbols?: boolean;
    /**
     * Whether to show search.
     * @default true
     */
    search?: boolean;
    /**
     * Whether to hide categories.
     * @default false
     */
    hideCategories?: boolean;
    /**
     * Filter blocks.
     * @example
     * ({ blocks }) => {
     *  return blocks.filter(block => block.category?.getLabel() === 'Basic');
     * }
     */
    blocks?: '__fn__';
    /**
     * Custom layout for rendering single blocks.
     * @examples
     * itemLayout: ({ block, attributes }) => ({
     *  type: 'column',
     *  children: [
     *    { type: 'custom', render: () => block.getMedia() },
     *    { type: 'text', content: block.getLabel() }
     *  ]
     * })
     */
    itemLayout?: '__fn__';
}
