import { StudioLayouts } from '.';
import type { StudioLayoutBasePropsConfig } from './StudioBaseSchema';
export interface StudioLayoutSidebarTopConfig extends Omit<StudioLayoutBasePropsConfig, 'htmlAttrs'> {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.sidebarTop}`;
    /**
     * The height of the top bar.
     * @example 50
     */
    height?: number | string;
    /**
     * The properties for the left container of the top bar.
     * @example { buttons: [ { type: 'button', icon: 'menu', onClick: 'toggleSidebar' } ] }
     */
    leftContainer?: object;
    /**
     * The properties for the right container of the top bar.
     * @example { buttons: [ { type: 'button', icon: 'menu', onClick: 'toggleSidebar' } ] }
     */
    rightContainer?: object;
    /**
     * The properties for the devices section of the top bar.
     * @example { style: { width: 200 } }
     */
    devices?: 'DevicesProps';
}
