import { StudioLayouts } from '.';
import type { StudioLayoutFieldBaseConfig } from './StudioBaseSchema';
export interface StudioLayoutTabsConfig extends Pick<StudioLayoutFieldBaseConfig, 'onChange' | 'editorEvents' | 'className' | 'style' | 'id'> {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.tabs}`;
    /**
     * Variant of the tabs.
     * @example "pills"
     */
    variant?: string;
    /**
     * Tab id value to select on initial render.
     * @example "tab1"
     */
    value?: string;
    /**
     * Tabs configuration.
     * @example [
     *   {
     *     id: "tab1",
     *     label: "Tab 1",
     *     children: ['Content Tab 1']
     *   }
     * ]
     */
    tabs: object[];
}
