import type { Component } from 'grapesjs';
export declare const tsDuration = 150;
export declare enum ThemeClassName {
    txt = "gs-theme-cl-txt",
    bg = "gs-theme-cl-bg",
    br = "gs-theme-cl-br",
    bgA = "gs-theme-cl-bgA",
    bgA2 = "gs-theme-cl-bgA2",
    hBgAct = "gs-theme-cl-hBgAct",
    hBgA2 = "gs-theme-cl-hBgA2",
    tA = "gs-theme-cl-tA",
    tAo = "gs-theme-cl-tAo",
    hTAo = "gs-theme-cl-hTAo",
    grouphTAo = "gs-theme-cl-grouphTAo",
    bA = "gs-theme-cl-bA",
    bg0 = "gs-theme-cl-bg0",
    bgH = "gs-theme-cl-bgH",
    hBgH = "gs-theme-cl-hBgH",
    bgH2 = "gs-theme-cl-bgH2",
    hBgH2 = "gs-theme-cl-hBgH2",
    sel = "gs-theme-cl-sel",
    selBr = "gs-theme-cl-selBr",
    cmp = "gs-theme-cl-cmp",
    cmpBgSoft = "gs-theme-cl-cmpBgSoft",
    cmpBgSoftX = "gs-theme-cl-cmpBgSoftX",
    cmpBr = "gs-theme-cl-cmpBr",
    cmpSymbol = "gs-theme-cl-cmpSymbol",
    cmpBgSymbolSoft = "gs-theme-cl-cmpBgSymbolSoft",
    cmpBgSymbolSoftX = "gs-theme-cl-cmpBgSymbolSoftX",
    cmpSymbolBr = "gs-theme-cl-cmpSymbolBr",
    cmpTxtActive = "gs-theme-cl-cmpTxtActive",
    focus = "gs-theme-ring-focus",
    inputText = "gs-theme-elStyles-inputText"
}
export declare const cl: {
    /** background transparent */
    bgTr: string;
    /** text */
    txt: string;
    /** text low emphasis */
    txtLowEmphasis: string;
    /** text high emphasis */
    txtHighEmphasis: string;
    /** text high emphasis hovered */
    txtHighEmphasisH: string;
    /** text active */
    tA: string;
    /** text active opaque */
    tAo: string;
    /** text active hovered opaque */
    hTAo: string;
    /** text active group hovered opaque */
    grouphTAo: string;
    /** border active */
    bA: string;
    /** background active */
    bgA: string;
    /** background active level 2 */
    bgA2: string;
    /** background opaque */
    bgO: string;
    /** background */
    bg: string;
    /** background that blurs content behind it */
    bgBlur: string;
    /** background heading */
    bgH: string;
    /** background heading 75 */
    bgH75: string;
    /** background hovered heading */
    hBgH: string;
    /** background heading 2 */
    bgH2: string;
    /** background hovered heading 2 */
    hBgH2: string;
    /** background hovered active */
    hBgAct: string;
    /** background hovered active 2 */
    hBgA2: string;
    /** background hovered dark */
    hBgDark: string;
    /** selector */
    sel: string;
    /** selector border */
    selBr: string;
    /** component */
    cmp: string;
    /** component symbol */
    cmpSymbol: string;
    /** component background soft */
    cmpBgSoft: string;
    /** component background symbol soft */
    cmpBgSymbolSoft: string;
    /** component background soft X?? */
    cmpBgSoftX: string;
    /** component background symbol soft X?? */
    cmpBgSymbolSoftX: string;
    /** component text active */
    cmpTxtActive: string;
    /** component border */
    cmpBr: string;
    /** component symbol border */
    cmpSymbolBr: string;
    /** component target background */
    cmpTargetBg: string;
    /** component target background opaque */
    cmpTargetBgOpac: string;
    /** component target border */
    cmpTargetBr: string;
    /** text warning */
    tW: string;
    /** background warning */
    bgW: string;
    /** background red */
    bgRed: string;
    /** hovered background red */
    hBgRed: string;
    /** hovered background warning */
    hBgW: string;
    /** border */
    br: string;
    brRed: string;
    /** border light */
    brLight: string;
};
/** transitions */
export declare const ts: {
    enter: string;
    enterFrom: string;
    enterTo: string;
    leave: string;
    leaveFrom: string;
    leaveTo: string;
};
/** transition opacity enter */
export declare const tsOpacEnter: {
    enter: string;
    enterFrom: string;
    enterTo: string;
};
/** transition opacity leave */
export declare const tsOpacLeave: {
    leave: string;
    leaveFrom: string;
    leaveTo: string;
};
/** transition opacity */
export declare const tsOpac: {
    leave: string;
    leaveFrom: string;
    leaveTo: string;
    enter: string;
    enterFrom: string;
    enterTo: string;
};
/** padding */
export declare const pad: {
    xy: string;
    xyS: string;
    xyS2: string;
    x: string;
    xS: string;
    y: string;
    s: string;
};
/** popover */
export declare const pop: {
    bg: string;
    bgH: string;
};
/** tooltip */
export declare const toolt: {
    bg: string;
    txt: string;
    block: string;
};
export declare const br: {
    /** rounded */
    rnd: string;
    pill: string;
    /** border */
    b: string;
    /** border transparent */
    bT: string;
    /** border super? */
    bS: string;
    /** border top */
    bt: string;
    /** border bottom */
    bb: string;
    /** border right */
    br: string;
    /** border left */
    bl: string;
    /** border active */
    bA: string;
};
export declare const ring: {
    focus: string;
    deepFocus: string;
};
export declare const icon: {
    s3x: string;
    s2x: string;
    sx: string;
    s: string;
    m: string;
    l: string;
};
/** special effects */
export declare const fx: {
    click: string;
    hover: string;
    hoverGroup: string;
    dot: string;
    scrollX: string;
    scrollY: string;
    txtEllips: string;
    coverAbs: string;
    hiddenVisually: string;
    disabled: string;
    disabledM: string;
    noFocusOut: string;
    spin: string;
};
export declare const elStyles: {
    link: string;
    inputText: string;
};
export declare const utils: {
    itemList: ({ index, open, length }?: {
        index?: number | undefined;
        open?: boolean | undefined;
        length?: number | undefined;
    }) => string;
};
export declare const getThemeColors: (isDark: boolean) => {
    bg: string;
    text: string;
    link: string;
};
export declare const getComponentColorClasses: (cmp?: Component) => {
    isSymbol: boolean;
    bg: string;
    bgSoft: string;
    bgSoftX: string;
    border: string;
    txt: string;
};
declare const Theme: {
    ts: {
        enter: string;
        enterFrom: string;
        enterTo: string;
        leave: string;
        leaveFrom: string;
        leaveTo: string;
    };
    pad: {
        xy: string;
        xyS: string;
        xyS2: string;
        x: string;
        xS: string;
        y: string;
        s: string;
    };
    pop: {
        bg: string;
        bgH: string;
    };
    br: {
        /** rounded */
        rnd: string;
        pill: string;
        /** border */
        b: string;
        /** border transparent */
        bT: string;
        /** border super? */
        bS: string;
        /** border top */
        bt: string;
        /** border bottom */
        bb: string;
        /** border right */
        br: string;
        /** border left */
        bl: string;
        /** border active */
        bA: string;
    };
    cl: {
        /** background transparent */
        bgTr: string;
        /** text */
        txt: string;
        /** text low emphasis */
        txtLowEmphasis: string;
        /** text high emphasis */
        txtHighEmphasis: string;
        /** text high emphasis hovered */
        txtHighEmphasisH: string;
        /** text active */
        tA: string;
        /** text active opaque */
        tAo: string;
        /** text active hovered opaque */
        hTAo: string;
        /** text active group hovered opaque */
        grouphTAo: string;
        /** border active */
        bA: string;
        /** background active */
        bgA: string;
        /** background active level 2 */
        bgA2: string;
        /** background opaque */
        bgO: string;
        /** background */
        bg: string;
        /** background that blurs content behind it */
        bgBlur: string;
        /** background heading */
        bgH: string;
        /** background heading 75 */
        bgH75: string;
        /** background hovered heading */
        hBgH: string;
        /** background heading 2 */
        bgH2: string;
        /** background hovered heading 2 */
        hBgH2: string;
        /** background hovered active */
        hBgAct: string;
        /** background hovered active 2 */
        hBgA2: string;
        /** background hovered dark */
        hBgDark: string;
        /** selector */
        sel: string;
        /** selector border */
        selBr: string;
        /** component */
        cmp: string;
        /** component symbol */
        cmpSymbol: string;
        /** component background soft */
        cmpBgSoft: string;
        /** component background symbol soft */
        cmpBgSymbolSoft: string;
        /** component background soft X?? */
        cmpBgSoftX: string;
        /** component background symbol soft X?? */
        cmpBgSymbolSoftX: string;
        /** component text active */
        cmpTxtActive: string;
        /** component border */
        cmpBr: string;
        /** component symbol border */
        cmpSymbolBr: string;
        /** component target background */
        cmpTargetBg: string;
        /** component target background opaque */
        cmpTargetBgOpac: string;
        /** component target border */
        cmpTargetBr: string;
        /** text warning */
        tW: string;
        /** background warning */
        bgW: string;
        /** background red */
        bgRed: string;
        /** hovered background red */
        hBgRed: string;
        /** hovered background warning */
        hBgW: string;
        /** border */
        br: string;
        brRed: string;
        /** border light */
        brLight: string;
    };
    icon: {
        s3x: string;
        s2x: string;
        sx: string;
        s: string;
        m: string;
        l: string;
    };
    fx: {
        click: string;
        hover: string;
        hoverGroup: string;
        dot: string;
        scrollX: string;
        scrollY: string;
        txtEllips: string;
        coverAbs: string;
        hiddenVisually: string;
        disabled: string;
        disabledM: string;
        noFocusOut: string;
        spin: string;
    };
    toolt: {
        bg: string;
        txt: string;
        block: string;
    };
};
export default Theme;
