import type { Editor } from 'grapesjs';
import { Store } from '.';
import { FontWithFamily, InternalFont } from '../typeConfigs/shared';
import { DefaultFont, FontOption } from '../types';
export interface AddFontOptions {
    skipUpdate?: boolean;
    overwrite?: boolean;
}
export declare class FontsStore {
    store: Store;
    fonts: Record<string, InternalFont>;
    sdkDefaultFonts?: DefaultFont[];
    get staticFonts(): FontOption[];
    get defaultWebFonts(): InternalFont[];
    get sortedFonts(): InternalFont[];
    get fontFamilyOptions(): import("../components/SelectField").Option[];
    get sdkFontOptions(): import("../types").FontsConfig | undefined;
    get enableFontManager(): boolean | undefined;
    get sdkShowProjectFonts(): boolean | undefined;
    get sdkAddFonts(): boolean | undefined;
    constructor(store: Store);
    loadFonts(): void;
    loadProjectFonts(): void;
    loadDefaultFonts(): void;
    getFont(family: string): InternalFont | undefined;
    addFont(font: FontWithFamily, { skipUpdate, overwrite }?: AddFontOptions): void;
    removeFont(family: string): void;
    updateProjectFonts(editor: Editor): void;
}
export declare const useFontsStore: () => FontsStore;
