import { Store } from '.';
import { StudioCustomLayoutProps } from '../components/public/StudioCustomLayout';
import { LayoutCommandProps, LayoutConfig } from '../types';
import { StudioBaseLayoutState } from '../components/public/StudioBase';
export declare class LayoutStore {
    store: Store;
    customConfig?: LayoutConfig;
    layouts: LayoutCommandProps[];
    layoutsById: Map<string, {
        state: StudioBaseLayoutState;
        setState: (props: StudioBaseLayoutState) => void;
    }>;
    constructor(store: Store);
    get editor(): import("grapesjs").Editor | undefined;
    setCustomConfig(config: LayoutConfig): void;
    add(id: string, props: Omit<LayoutCommandProps, 'id'>): void;
    remove(id: string, opts?: {
        force?: boolean;
        layout?: LayoutCommandProps;
    }): void;
    get(id: string): LayoutCommandProps | undefined;
    clear(): void;
    get layoutChildren(): Map<string, StudioCustomLayoutProps>;
}
export declare const useLayoutStore: () => LayoutStore;
export declare const getLayoutStore: () => LayoutStore;
